/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.lpar;

import com.ibm.hsc.fsp.cmdhelpers.FspLparProcessingInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspTaggedIosForOs400;
import com.ibm.hsc.fsp.cmdhelpers.FspVspAttr;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.lpar.OmLparInstUpdater;
import com.ibm.hsc.objmgr.lpar.OmLparMgr;
import com.ibm.hsc.objmgr.lpar.OmLparVsmcaUpdater;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import com.ibm.hsc.rep.v50.R50Define;
import com.ibm.hsc.rep.v50.R50Partition;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class OmLparActResourceUpdater {
    private OmLparMgr mLparMgr;
    private OmCecMgr mCecMgr;
    private RObject mLparObj;
    private String mLparName;
    private UnsignedInt16 mLparId;
    private OmLparInstUpdater mLparInstUpdater;
    private static final UnsignedInt8 ff8 = new UnsignedInt8(255);
    private static final UnsignedInt8 zero8 = new UnsignedInt8(0);
    private static final UnsignedInt16 zero16 = new UnsignedInt16(0);
    private static final UnsignedInt32 zero32 = new UnsignedInt32(0L);

    public OmLparActResourceUpdater(OmLparMgr omLparMgr) {
        this.mLparMgr = omLparMgr;
        this.mLparObj = this.mLparMgr.getObject();
        this.mLparName = this.mLparMgr.getLparName();
        this.mCecMgr = this.mLparMgr.getCecMgr();
        int n = Integer.parseInt(this.mLparName.substring(0, this.mLparName.indexOf("*")));
        this.mLparId = new UnsignedInt16(n);
        this.mLparInstUpdater = new OmLparInstUpdater(omLparMgr);
    }

    public void updateTaggedIoForOS400() {
        try {
            FspTaggedIosForOs400 fspTaggedIosForOs400 = this.mCecMgr.getCmdHelper().getTaggedIosForOs400(this.mLparId);
            this.mLparInstUpdater.updateTaggedIO(fspTaggedIosForOs400);
        }
        catch (Throwable throwable) {
            System.out.println("Error in updateTaggedIoForOS400...");
            throwable.printStackTrace();
        }
    }

    public void freePendingProc(UnsignedInt8 unsignedInt8) {
        boolean bl = false;
        FspLparProcessingInfo fspLparProcessingInfo = new FspLparProcessingInfo();
        fspLparProcessingInfo.setProcType(unsignedInt8);
        fspLparProcessingInfo.setSharingMode(ff8);
        fspLparProcessingInfo.setMinProcs(zero16);
        fspLparProcessingInfo.setAllocProcs(zero16);
        fspLparProcessingInfo.setMaxProcs(zero16);
        if (unsignedInt8.intValue() != 255) {
            fspLparProcessingInfo.setMinProcUnits(zero32);
            fspLparProcessingInfo.setAllocProcUnits(zero32);
            fspLparProcessingInfo.setMaxProcUnits(zero32);
            fspLparProcessingInfo.setUncappedWeight(zero8);
        }
        try {
            this.mLparInstUpdater.updatePendingLparProcessingInfo(fspLparProcessingInfo);
        }
        catch (Throwable throwable) {
            System.out.println("Error in freePendingProc");
            throwable.printStackTrace();
        }
    }

    public void freePendingMem() {
        try {
            this.mLparObj.setProperty(R50Partition.Index_PendMinMem, (Object)zero32);
            this.mLparObj.setProperty(R50Partition.Index_PendAllocMem, (Object)zero32);
            this.mLparObj.setProperty(R50Partition.Index_PendMaxMem, (Object)zero32);
        }
        catch (Throwable throwable) {
            System.out.println("Error in freePendingMem");
            throwable.printStackTrace();
        }
    }

    public void free5250() {
        try {
            this.mLparObj.setProperty(R50Partition.Index_PendMinInteractivePerf, (Object)zero16);
            this.mLparObj.setProperty(R50Partition.Index_PendAllocInteractivePerf, (Object)zero16);
            this.mLparObj.setProperty(R50Partition.Index_PendMaxInteractivePerf, (Object)zero16);
        }
        catch (Throwable throwable) {
            System.out.println("Error in free5250..");
            throwable.printStackTrace();
        }
    }

    public void setLparDefState(UnsignedInt8 unsignedInt8) {
        try {
            this.mLparObj.setProperty(R50Partition.Index_DefinitionState, (Object)unsignedInt8);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setLparIOPools(Vector vector) {
        Vector vector2 = new Vector();
        if (vector != null) {
            vector2 = (Vector)vector.clone();
        }
        Vector<UnsignedInt16> vector3 = new Vector<UnsignedInt16>();
        try {
            Object object;
            Object object2;
            RObject rObject;
            int n;
            Vector vector4 = this.mLparObj.associators(R50Define.AID_IBMHSC_LparInIOFailOverPool);
            if (vector4 != null && vector4.size() > 0) {
                for (n = 0; n < vector4.size(); ++n) {
                    rObject = (RObject)vector4.elementAt(n);
                    object2 = (String)rObject.getProperty("CollectionID");
                    object = new UnsignedInt16(Integer.parseInt((String)object2));
                    if (vector != null && vector.size() > 0 && vector.contains(object)) {
                        vector2.remove(object);
                        continue;
                    }
                    vector3.add((UnsignedInt16)object);
                }
            }
            if (vector2 != null && vector2.size() > 0) {
                for (n = 0; n < vector2.size(); ++n) {
                    rObject = (UnsignedInt16)vector2.elementAt(n);
                    object2 = new RObjectId(this.mLparObj.getNameSpaceId(), R50Define.CID_IBMHSC_IOFailOverPool);
                    ((RObjectId)object2).setKeyValue(0, this.mLparMgr.getCecMgr().getCecName());
                    ((RObjectId)object2).setKeyValue(1, "IBMHSC_ComputerSystem");
                    ((RObjectId)object2).setKeyValue(2, rObject.toString());
                    object = ((RObjectId)object2).getObject();
                    if (object == null) {
                        object = new RObject((RObjectId)object2);
                        ((RObject)object).addInstance();
                        ((RObject)object).addAssociation(R50Define.AID_IBMHSC_CompSysIOFailOverPool, this.mLparMgr.getCecMgr().getObjectId());
                    }
                    this.mLparObj.addAssociation(R50Define.AID_IBMHSC_LparInIOFailOverPool, (RObjectId)object2);
                }
            }
            if (vector3 != null && vector3.size() > 0) {
                for (n = 0; n < vector3.size(); ++n) {
                    rObject = (UnsignedInt16)vector3.elementAt(n);
                    object2 = new RObjectId(this.mLparObj.getNameSpaceId(), R50Define.CID_IBMHSC_IOFailOverPool);
                    ((RObjectId)object2).setKeyValue(0, this.mLparMgr.getCecMgr().getCecName());
                    ((RObjectId)object2).setKeyValue(1, "IBMHSC_ComputerSystem");
                    ((RObjectId)object2).setKeyValue(2, rObject.toString());
                    object = ((RObjectId)object2).getObject();
                    if (object == null) continue;
                    this.mLparObj.deleteAssociation(R50Define.AID_IBMHSC_LparInIOFailOverPool, (RObjectId)object2);
                    if (((RObject)object).hasAssociation(R50Define.AID_IBMHSC_LparInIOFailOverPool) || ((RObject)object).hasAssociation(R50Define.AID_IBMHSC_SlotInIOFailOverPool)) continue;
                    ((RObject)object).deleteInstance();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void updateLparPendProcInfo(UnsignedInt8 unsignedInt8, UnsignedInt8 unsignedInt82, UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt16 unsignedInt163, UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, UnsignedInt8 unsignedInt83) {
        try {
            RObject rObject = this.mLparMgr.getObject();
            rObject.setProperty(R50Partition.Index_PendMinProcs, (Object)unsignedInt16);
            rObject.setProperty(R50Partition.Index_PendAllocProcs, (Object)unsignedInt162);
            rObject.setProperty(R50Partition.Index_PendMaxProcs, (Object)unsignedInt163);
            rObject.setProperty(R50Partition.Index_PendMinProcUnits, (Object)unsignedInt32);
            rObject.setProperty(R50Partition.Index_PendAllocProcUnits, (Object)unsignedInt322);
            rObject.setProperty(R50Partition.Index_PendMaxProcUnits, (Object)unsignedInt323);
            rObject.setProperty(R50Partition.Index_PendProcMode, (Object)unsignedInt8);
            rObject.setProperty(R50Partition.Index_PendSharingMode, (Object)unsignedInt82);
            rObject.setProperty(R50Partition.Index_PendUncappedWeight, (Object)unsignedInt83);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void updateLparPendCPWInfo(UnsignedInt16 unsignedInt16, UnsignedInt16 unsignedInt162, UnsignedInt16 unsignedInt163) {
        try {
            this.mLparObj.setProperty(R50Partition.Index_PendMinInteractivePerf, (Object)unsignedInt16);
            this.mLparObj.setProperty(R50Partition.Index_PendAllocInteractivePerf, (Object)unsignedInt162);
            this.mLparObj.setProperty(R50Partition.Index_PendMaxInteractivePerf, (Object)unsignedInt163);
        }
        catch (Throwable throwable) {
            System.out.println("Error in free5250..");
            throwable.printStackTrace();
        }
    }

    public void updateLparPendMem(UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323) {
        try {
            this.mLparObj.setProperty(R50Partition.Index_PendMinMem, (Object)unsignedInt32);
            this.mLparObj.setProperty(R50Partition.Index_PendAllocMem, (Object)unsignedInt322);
            this.mLparObj.setProperty(R50Partition.Index_PendMaxMem, (Object)unsignedInt323);
        }
        catch (Throwable throwable) {
            System.out.println("Error in freePendingMem");
            throwable.printStackTrace();
        }
    }

    public void updateMMLparPendMem(UnsignedInt32 unsignedInt32, UnsignedInt32 unsignedInt322, UnsignedInt32 unsignedInt323, UnsignedInt32 unsignedInt324, UnsignedInt32 unsignedInt325, UnsignedInt32 unsignedInt326) {
        try {
            this.mLparObj.setProperty(R50Partition.Index_Reserve1PendMinMem, (Object)unsignedInt32);
            this.mLparObj.setProperty(R50Partition.Index_Reserve1PendAllocMem, (Object)unsignedInt322);
            this.mLparObj.setProperty(R50Partition.Index_Reserve1PendMaxMem, (Object)unsignedInt323);
            this.mLparObj.setProperty(R50Partition.Index_Reserve2PendMinMem, (Object)unsignedInt324);
            this.mLparObj.setProperty(R50Partition.Index_Reserve2PendAllocMem, (Object)unsignedInt325);
            this.mLparObj.setProperty(R50Partition.Index_Reserve2PendMaxMem, (Object)unsignedInt326);
        }
        catch (Throwable throwable) {
            System.out.println("Error in freePendingMem");
            throwable.printStackTrace();
        }
    }

    public void clearVIO(UnsignedInt16 unsignedInt16) {
        try {
            RObjectId rObjectId = new RObjectId(this.mLparObj.getNameSpaceId(), R50Define.CID_IBMHSC_VirtualSerial);
            rObjectId.setKeyValue(0, "IBMHSC_VirtualSerial");
            rObjectId.setKeyValue(1, unsignedInt16.toString());
            rObjectId.setKeyValue(2, "IBMHSC_Partition");
            rObjectId.setKeyValue(3, this.mLparMgr.getLparName());
            RObject rObject = rObjectId.getObject();
            if (rObject != null) {
                this.mLparMgr.getLparVserialUpdater().deleteVserial(rObject);
                return;
            }
            rObjectId = new RObjectId(this.mLparObj.getNameSpaceId(), R50Define.CID_IBMHSC_VirtualSCSI);
            rObjectId.setKeyValue(0, "IBMHSC_VirtualSCSI");
            rObjectId.setKeyValue(1, unsignedInt16.toString());
            rObjectId.setKeyValue(2, "IBMHSC_Partition");
            rObjectId.setKeyValue(3, this.mLparMgr.getLparName());
            rObject = rObjectId.getObject();
            if (rObject != null) {
                this.mLparMgr.getLparVscsiUpdater().deleteVscsi(rObject);
                return;
            }
            rObjectId = new RObjectId(this.mLparObj.getNameSpaceId(), R50Define.CID_IBMHSC_VirtualEthernet);
            rObjectId.setKeyValue(0, "IBMHSC_VirtualEthernet");
            rObjectId.setKeyValue(1, unsignedInt16.toString());
            rObjectId.setKeyValue(2, "IBMHSC_Partition");
            rObjectId.setKeyValue(3, this.mLparMgr.getLparName());
            rObject = rObjectId.getObject();
            if (rObject != null) {
                this.mLparMgr.getLparVethUpdater().deleteVeth(rObject);
                return;
            }
            rObjectId = new RObjectId(this.mLparObj.getNameSpaceId(), R50Define.CID_IBMHSC_VirtualSMCA);
            rObjectId.setKeyValue(0, "IBMHSC_VirtualSMCA");
            rObjectId.setKeyValue(1, unsignedInt16.toString());
            rObjectId.setKeyValue(2, "IBMHSC_Partition");
            rObjectId.setKeyValue(3, this.mLparMgr.getLparName());
            rObject = rObjectId.getObject();
            if (rObject != null) {
                OmLparVsmcaUpdater omLparVsmcaUpdater = new OmLparVsmcaUpdater(this.mLparMgr);
                omLparVsmcaUpdater.deleteVsmca(rObject);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void updateVspAttr(FspVspAttr fspVspAttr) {
        try {
            this.mLparObj.setProperty(R50Partition.Index_BootMode, (Object)fspVspAttr.getBootMode());
            this.mLparObj.setProperty(R50Partition.Index_IPLSource, (Object)fspVspAttr.getIplSource());
            this.mLparObj.setProperty(R50Partition.Index_PowerOnWithHypervisor, (Object)fspVspAttr.getAutoIpl());
            this.mLparObj.setProperty(R50Partition.Index_Keylock, (Object)fspVspAttr.getKeylock());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void updateLparPowerCtrlLpars(Vector vector) {
        try {
            this.mLparObj.setProperty(R50Partition.Index_HostingPartitions, (Object)vector);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void updateLparOptiSetting(UnsignedInt8 unsignedInt8, UnsignedInt8 unsignedInt82) {
        try {
            this.mLparObj.setProperty(R50Partition.Index_VirtualOptiConnect, (Object)unsignedInt8);
            this.mLparObj.setProperty(R50Partition.Index_HSLOptiConnect, (Object)unsignedInt82);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

